extends CanvasLayer

@export var texture : Texture2D
@export var max_x_pixel_offset : float = 6.0
@export var lerp_speed : float = 6.0

@onready var texture_rect: TextureRect = $TextureRect
const ICON = preload("res://icon.svg")

func _ready():
	if texture:
		texture_rect.texture = texture
	else:
		texture_rect.texture = ICON
		
	texture_rect.max_x_pixel_offset = max_x_pixel_offset
	texture_rect.lerp_speed = lerp_speed
	texture_rect.set_pos()
