extends TextureRect

var max_x_pixel_offset : float
var lerp_speed : float


var start_x_pos : float
var start_y_pos : float
var enabled : bool = true

func set_pos():
	start_x_pos = -(texture.get_size().x - get_viewport().get_visible_rect().size[0]) / 2.0
	start_y_pos = -(texture.get_size().y - get_viewport().get_visible_rect().size[1]) / 2.0

func _ready() -> void:
	start_x_pos = global_position.x
	start_y_pos = global_position.y
	
func _process(delta: float) -> void:
	if !enabled:
		return
	
	var x_viewport : int = get_viewport().get_visible_rect().size[0]
	var y_viewport : int = get_viewport().get_visible_rect().size[1]
	var cur_mouse_pos_x : int = clamp(get_viewport().get_mouse_position()[0], 0, x_viewport)
	var cur_mouse_pos_y : int = clamp(get_viewport().get_mouse_position()[1], 0, y_viewport)
	
	var max_y_pixel_offset : float = (y_viewport * max_x_pixel_offset) / x_viewport
	
	var x_center_pos : int = x_viewport/2
	var y_center_pos : int = y_viewport/2
	
	var x_mouse_pos_center_mod : int = cur_mouse_pos_x - x_center_pos
	var y_mouse_pos_center_mod : int = cur_mouse_pos_y - y_center_pos
	
	var x_img_scaler : float = float(x_mouse_pos_center_mod) / x_center_pos
	var y_img_scaler : float = float(y_mouse_pos_center_mod) / y_center_pos
	
	global_position.x = lerp(global_position.x, start_x_pos + x_img_scaler * max_x_pixel_offset, delta * lerp_speed)
	global_position.y = lerp(global_position.y, start_y_pos + y_img_scaler * max_y_pixel_offset, delta * lerp_speed)

	
func enable():
	enabled = true
	
func disable():
	enabled = false
	global_position.x = start_x_pos
	global_position.y = start_y_pos
